#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// The Butterfly EffectMod01.fsh  by BigWIngs
//https://www.shadertoy.com/view/XsVGRV
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// "The Butterfly Effect" by Martijn Steinrucken aka BigWings - 2016
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
// Email:countfrolic@gmail.com Twitter:@The_ArtOfCode

#define PI 3.141592653589793238
#define TWOPI 6.283185307179586
#define S01(x, offset, frequency) (sin((x+offset)*frequency*TWOPI)*.5+.5)
#define S(x, offset, frequency) sin((x+offset)*frequency*TWOPI)
#define B(x,y,z) S(x, x+fwidth(z), z)*S(y+fwidth(z), y, z)
#define saturate(x) clamp(x,0.,1.)
float dist2(vec2 P0, vec2 P1) { vec2 D=P1-P0; return dot(D,D); }

float SHAPESHIFT=0.;

float hash(vec2 seed) {
	seed *= 213234598766.2345768238784;
    return fract(sin(seed.x)*1234765.876 + cos(seed.y)*8764238764.98787687);
}

float smooth90(float x, float power) {
    // like smoothstep, only 90 degrees rotated
	
    return (1.-x)*pow(x, power) + x * (1.-pow(1.-x, power));
}

vec2 hash2( vec2 p ) { p=vec2(dot(p,vec2(127.1,311.7)),dot(p,vec2(269.5,183.3))); return fract(sin(p)*18.5453); }

vec4 hash4(float seed) {
	vec2 n1 = hash2(vec2(seed, sin(seed*123432.2345)));
    vec2 n2 = hash2(n1);
    
    return vec4(n1, n2);
}

// return distance, and cell id
vec2 voronoi( in vec2 x )
{
    vec2 n = floor( x );
    vec2 f = fract( x );

	vec3 m = vec3( 8.0 );
    for( float j=-1.; j<=1.; j++ )		// iterate cell neighbors
    for( float i=-1.; i<=1.; i++ )
    {
        vec2  g = vec2( i, j );			// vector holding offset to current cell
        vec2  o = hash2( n + g );		// unique random offset per cell
      	o.y*=.1;
        vec2  r = g - f + o;			// current pixel pos in local coords
	   
		float d = dot( r, r );			// squared dist from center of local coord system
        
        if( d<m.x )						// if dist is smallest...
            m = vec3( d, o );			// .. save new smallest dist and offset
    }

    return vec2( sqrt(m.x), m.y+m.z );
}

float skewcirc(vec2 uv, vec2 p, float size, float skew, float blur) {
	uv -= p;
    
    uv.x *= 1.+uv.y*skew;
    
    float c = length(uv);
    c = smoothstep(size+blur, size-blur, c);
    return c;
}

float curve(float x, vec4 offs, vec4 amp, vec4 pulse) {
    // returns a fourier-synthesied signal followed by a band-filter
	x *= 3. * pulse.w;
    
    vec4 c = vec4(	S(x, offs.x, 1.),
                  	S(x, offs.y, 2.),
                 	S(x, offs.z, 4.),
                 	S(x, offs.w, 8.));

    float v = dot(c, amp*vec4(1., .5, .25, .125));
    
    pulse.y/=2.;
    
    v *= smoothstep(pulse.x-pulse.y-pulse.z, pulse.x-pulse.y, x);
    v *= smoothstep(pulse.x+pulse.y+pulse.z, pulse.x+pulse.y, x); 
    return v;
}

vec4 Wing(vec2 st, vec2 id, float radius, vec2 center, vec4 misc, vec4 offs, vec4 amp, vec4 pattern1, vec4 global, vec4 detail) {
	// returns a wings shape in the lower right quadrant (.5<st.x<1)
    // we do this by drawing a circle... (white if st.y<radius, black otherwise)
    // ...and scaling the radius based on st.x 
    // when st.x<.5 or st.x>1 radius will be 0, inside of the interval it will be 
    // an upside down parabola with a maximum of 1
    
    vec2 o=vec2(0.);
    
    vec2 colId = hash2(id);
    
    colId.x *= mix( 1., floor(cos(iTime*.125)+.5)+.00015, SHAPESHIFT);
    colId.y *= mix(1., floor(cos(iTime*.25)+.5)+.0001, SHAPESHIFT);
    
    // use upsidedown parabola 1-((x - center)*4)^2
    float b = mix(center.x, center.y, st.x);	// change the center based on the angle to further control the wings shape
    float a = (st.x-b)*4.;			// *4 so curve crosses 0 at .5 and 1.
    a *= a;
    a = 1.-a;						// flip curve upside down
    float f = max(0., a);			// make curve 0 outside of interval
    
    f = pow(f, mix(.5, 3., misc.x));
    
    o.x = st.x;
    
    float r = 0.;
    float x = st.x*2.;
    
    vec2 vor = voronoi(vec2(st.x, st.y*.1)*40.*detail.z);
    
    r = curve(x-b, offs, amp,vec4(global.x, global.y, max(.1, global.z), .333));

    r = (radius + r*.1)*f;
    
    float edge = 0.01;//max(.001, fwidth(r))*4.;
    
    o.x = smoothstep(r, r-edge, st.y);
    o.y=r;
    
    float t = floor(iTime*2.)*SHAPESHIFT;
    
    
    vec3 edgeCol = hash4(colId.x+t).rgb;
    vec3 mainCol = hash4(colId.y+t).rgb;
    vec3 detailCol = cross(edgeCol, mainCol);
    
    vec3 col = mainCol;
    
    misc = pow(misc, vec4(10.));
    
    r -= misc.y*curve(x-b, amp, offs, vec4(offs.xw, amp.wz));
    
    float edgeBand =  smoothstep(r-edge*3.*misc.w, r, st.y);
    col = mix(col, edgeCol, edgeBand);
    r = st.y-r;
    
    float clockValue = curve(r*.5+.5, pattern1, offs, amp)*global.x;
    
    float distValue = curve(length(st-offs.yx), pattern1.wzyx, amp, global);
    
    col += (clockValue+pow(distValue,3.))*detail.z;
    
    
    float d= distance(st, fract(st*20.*detail.x*detail.x));
    col += st.y*st.y*smoothstep(.1, .0, d)*detail.w*5.*curve(st.x,pattern1, offs, amp);
    
    col *= mix(1., st.y*st.y*(1.-vor.x*vor.x)*15., detail.x*detail.w);
    
    return vec4(col, o.x);
}

vec4 body(vec2 uv, vec4 n) {
	
    float eyes = skewcirc(uv, vec2(.005, .06), .01, 0., 0.001);
    
    uv.x+=.01;
    uv.x *= 3.;
    
    vec2 p = vec2(-.0, 0.);
    float size = .08;
    float skew = 2.1;
    float blur = .005;
    
    float v = skewcirc(uv, p, size, skew, blur);
    
    p.y -= .1;
    uv.x *= mix(.5, 1.5, n.x);
    v += skewcirc(uv, p, size, skew, blur);
    
    vec4 col = n.w*.1+ vec4(.1)* saturate(1.-uv.x*10.)*mix(.1, .6, S01(uv.y, 0., mix(20., 40., n.y)));
    col +=.1;
    col.a = saturate(v);
    
    
    col = mix(col, n*n, eyes);
    
    return col;
}

float BlockWave(float x, float b, float c) {
	// expects 0<x<1
    // returns a block wave where b is the high part and c is the transition width
    
    return smoothstep(b-c, b, x)*smoothstep(1., 1.-c, x);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 m = iMouse.xy/iResolution.xy;
    
    float songLength=268.3;
    
    float loopNum = floor(iTime/songLength);
    float t=fract(iTime/songLength)*songLength;
    
    vec2 p = fragCoord.xy/iResolution.xy;
    vec2 uv = p;
    
    SHAPESHIFT = floor(fract(t/40.)+.5);		// turns the overall shapeshifting on or off
    
    p -=.5;	 // origin to center
    
     float camT = PI*t/16.;
    float camDive = 1.-(cos(camT)*.5+.5);		// up and down camera motion
    
   
    p =vec2(p.x*1.777, mix(p.y, smooth90(p.y+.5, .7)-.5, camDive));			// aspect ratio fix + a barrel distortion						

   p*=mix(.85, 5., camDive);
    
    p.y += floor(p.x+.5)*.5+.05;					// brick pattern = offset every other column
    
    p.y -= 8.*(camT+sin(camT+PI))/TWOPI;		// stop-go camera  motion
    
    vec2 id = floor(p+.5);						// tile-id
    p=fract(p+.5)-.5;							// p in tile-space
    
    p.x = abs(p.x);								// mirror wings

    float shapeShifter = floor(t/8.+.5)*floor(t/2.+.5)*SHAPESHIFT;			// only shapeshift when zoomed in
    shapeShifter += loopNum;
    
    float it = hash2(id+shapeShifter).x*10.+.25; // the only seed that will feed the entire thing
    
    vec4 pattern1 = hash4(it+.345);			// get a whole bunch of random numbers 
    vec4 n1 = hash4(it);
    vec4 n2 = hash4(it+.3);
    vec4 n3 = hash4(n1.x);
    vec4 global = hash4(it*12.);
    vec4 detail = hash4(it*-12.);
    vec4 nBody = hash4(it*.1425);
    
     p.x-=.01*n1.x;							// distance between wings
    
    vec4 col = vec4(1.);
	vec4 bodyCol = body(p, nBody);
    
    float wingFlap = pow(S01(t+hash2(id.xy).x*20., 10., .05), 60.)*camDive; 
    
     p.x *= mix(1.,20., wingFlap);
    
    vec2 st = vec2(atan(p.x, p.y), length(p));
   st.x /= PI;
   
    
    vec4 top = vec4(0.);
    if(st.x<.6)
    	top = Wing(st, id, .5, vec2(.25, .4), n1, n2, n3, pattern1, global, detail);
    vec4 bottom = vec4(0.);
    if(st.x>.4)
    	bottom = Wing(st, id, .4, vec2(.5, .75), n2, n3, n1, pattern1, global, detail); 
    
    wingFlap = (1.-wingFlap*.9);
    
    vec4 wings = mix(bottom, top, top.a);
    wings.rgb *= wingFlap;							// darken wings when they are back-to-back
    
  	col = mix(bodyCol*bodyCol.a, wings, wings.a);	// composite wings and body
    
    col *= smoothstep(0., 3., t)*smoothstep(268., 250., t);		// fade in at the start
   
    fragColor = vec4( col );
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

